/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.HashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.NBTTags;
import noppes.npcs.roles.JobItemGiver;

public class PlayerItemGiverData {
    private HashMap<Integer, Integer> chained;
    private HashMap<Integer, Long> itemgivers = new HashMap();

    public PlayerItemGiverData() {
        this.chained = new HashMap();
    }

    public int getItemIndex(JobItemGiver jobItemGiver) {
        if (this.chained.containsKey(jobItemGiver.itemGiverId)) {
            return this.chained.get(jobItemGiver.itemGiverId);
        }
        return 0;
    }

    public long getTime(JobItemGiver jobItemGiver) {
        return this.itemgivers.get(jobItemGiver.itemGiverId);
    }

    public boolean notInteractedBefore(JobItemGiver jobItemGiver) {
        return !this.itemgivers.containsKey(jobItemGiver.itemGiverId);
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.chained = NBTTags.getIntegerIntegerMap(compound.func_150295_c("ItemGiverChained", 10));
        this.itemgivers = NBTTags.getIntegerLongMap(compound.func_150295_c("ItemGiversList", 10));
    }

    public void saveNBTData(NBTTagCompound compound) {
        compound.func_74782_a("ItemGiverChained", (NBTBase)NBTTags.nbtIntegerIntegerMap(this.chained));
        compound.func_74782_a("ItemGiversList", (NBTBase)NBTTags.nbtIntegerLongMap(this.itemgivers));
    }

    public void setItemIndex(JobItemGiver jobItemGiver, int i) {
        this.chained.put(jobItemGiver.itemGiverId, i);
    }

    public void setTime(JobItemGiver jobItemGiver, long day) {
        this.itemgivers.put(jobItemGiver.itemGiverId, day);
    }
}

